"""Streamlit entry point for the CA Task Manager application."""

import os
import streamlit as st

from services.auth_service import AuthService
from ui_pages import login_page, home_page, employees_page, tasks_page, assignments_page, reports_page, settings_page


def main() -> None:
    """Main entrypoint for the Streamlit application."""
    st.set_page_config(page_title="CA Task Manager", layout="wide")

    if "logged_in" not in st.session_state:
        st.session_state.logged_in = False

    auth_service = AuthService()

    if not st.session_state.logged_in:
        login_page.render(auth_service)
        return

    st.sidebar.title("Navigation")
    choice = st.sidebar.radio(
        "Go to:",
        ["Home", "Employees", "Tasks", "Assignments", "Reports", "Settings"],
    )

    if choice == "Home":
        home_page.render()
    elif choice == "Employees":
        employees_page.render()
    elif choice == "Tasks":
        tasks_page.render()
    elif choice == "Assignments":
        assignments_page.render()
    elif choice == "Reports":
        reports_page.render()
    elif choice == "Settings":
        settings_page.render()


if __name__ == "__main__":
    main()
